
#include <stdio.h>
#include <stdarg.h>
#include "jmc_error.h"
#include "data.h"

extern int lineno;

int errorcount = 0, warningcount = 0;

void err_print(const char* fmt, va_list ap);

void err_print(const char* fmt, va_list ap) {
  char buf[512];

  vsprintf(buf, fmt, ap);
  //strcat(buf,"\n");
  fputs(buf,stderr);
  fflush(NULL);
}

/* Writes an error message to stderr */
void error(const char* fmt, ...) {
  va_list ap;

  errorcount++;

  fprintf(stderr, "Error, line %d: ", lineno);

  va_start(ap, fmt);
  err_print(fmt, ap);
  va_end(ap);

  if (errorcount == MAX_ERRORS) {
    fprintf(stderr, "Too many errors, aborting\n");
    err_report();
    exit(1);
  }
}

/* Writes a syntax error message to stderr */
void synerror(const char* fmt, ...) {
  va_list ap;

  errorcount++;

  fprintf(stderr, "Error, line %d: Syntax error, ", lineno);

  va_start(ap, fmt);
  err_print(fmt, ap);
  va_end(ap);

  if (errorcount == MAX_ERRORS) {
    fprintf(stderr, "Too many errors, aborting\n");
    err_report();
    exit(1);
  }
}

/* Writes an error message to stderr and aborts */
void fatalerror(const char* fmt, ...) {
  va_list ap;

  fprintf(stderr, "Error, line %d: ", lineno);

  va_start(ap, fmt);
  err_print(fmt, ap);
  va_end(ap);
  
  fprintf(stderr, "Fatal error, aborting\n");
  err_report();
  exit(1);
}

/* Writes a warning message to stderr */
void warning(const char* fmt, ...) {
  va_list ap;

  fprintf(stderr, "Warning, line %d: ", lineno);

  warningcount++;

  va_start(ap, fmt);
  err_print(fmt, ap);
  va_end(ap);
}

/* Writes an error message report */
void err_report(void) {
  if (errorcount != 0 || warningcount != 0)
    fprintf(stderr, "%d errors, %d warnings (%d patterns defined)\n",
            errorcount, warningcount, patt_size);
}

/* is it ok to continue? (zero errors) */
int ok_to_continue(void) {
  if (errorcount == 0)
    return 1;
  return 0;
}
