/* JMC - JuggleMaster Pattern Converter
 *
 * Version 1.0
 * Copyright (C) Per Johan Persson 2001
 *
 *
 * pdb_output.c - Creates the pdb output file
 *
 */

#include "data.h"
#include "xmem.h"

prc_t* prc_handle;

void add_styles(void);
void add_patterns(void);

/* open the database */
void open_database(char* filename) {
  prc_handle = prccreate(filename, "JMPalmDB", 
			 0x44415441, 0x4a4d504c, 0x0000);
}

/* close the database */
void close_database(void) {
  prcclose(prc_handle);
}

/* write the database */
void write_database(void) {
  int i;
  int dc_size = sizeof(UInt32)+((JML_MAX_NAMELEN+sizeof(UInt32))*cat_size);
  char* datachunk = (char*)xmalloc(dc_size);
  char* dcp = datachunk;

  /* record 1 is the header */
  new_record(&phd, sizeof(patt_header));

  /* record 2 is the style data */
  new_record(styledata, (unsigned short)styled_size);

  /* record 3 is the categories */
  for (i=0;i<cat_size;i++) {
    memcpy(dcp, categories[i]->name, JML_MAX_NAMELEN);
    dcp += JML_MAX_NAMELEN;
    memcpy(dcp, &(categories[i]->first_patt), sizeof(UInt32));
    dcp += sizeof(UInt32);
  }  

  new_record(datachunk, (unsigned short)dc_size);

  /* styles are added next */
  /*
  for (i=0;i<style_size;i++) {
    new_record(styles[i], sizeof(styledef));
  }
  */
  add_styles();

  /* finally add patterns */
  /*
  for (i=0;i<patt_size;i++) {
    new_record(patterns[i], sizeof(patterndef));
  }
  */
  add_patterns();

  xfree(datachunk);
}

/* pack and add styles */
void add_styles(void) {
  unsigned int datalen = 2 + JML_MAX_NAMELEN + sizeof(UInt16)*2;
  char* datachunk = (char*)xmalloc(datalen);
  char* dcp = datachunk;
  char buf = 0;
  int i;
  UInt8 name_len;
  UInt8 nullbyte = 0;

  for (i=0;i<style_size;i++) {
    name_len = (UInt8)strlen(styles[i]->name); 

    dcp = datachunk;

    memcpy(dcp, &(styles[i]->id), 1);
    dcp++;

    memcpy(dcp, &name_len, 1);
    dcp++;
    
    memcpy(dcp, styles[i]->name, name_len);
    dcp+=name_len;
    memcpy(dcp, &nullbyte, 1);
    dcp++;
    memcpy(dcp, &(styles[i]->length), sizeof(UInt16));
    dcp+=sizeof(UInt16);
    memcpy(dcp, &(styles[i]->offset), sizeof(UInt16));

    new_record(datachunk, (unsigned short)datalen);
  }
  
  xfree(datachunk);
}

/* OLD VERSION OF ADDSTYLES
void add_styles(void) {
  unsigned int datalen = 512;
  char* datachunk = (char*)xmalloc(datalen);
  char* dcp = datachunk;
  char buf = 0;
  int i;

  for (i=0;i<style_size;i++) {
    dcp = datachunk;

    memcpy(dcp, &(styles[i]->id), 1);
    dcp++;
    memcpy(dcp, styles[i]->name, JML_MAX_NAMELEN);
    dcp+=JML_MAX_NAMELEN;
    memcpy(dcp, &buf, 1); // alignment buffer
    dcp++;
    memcpy(dcp, &(styles[i]->length), sizeof(UInt16));
    dcp+=sizeof(UInt16);
    memcpy(dcp, &(styles[i]->offset), sizeof(UInt16));

    new_record(datachunk, datalen);
  }
  
  xfree(datachunk);
}
*/

void add_patterns(void) {
  /* 104 */
  /*
  unsigned int datalen = 2 + JML_MAX_NAMELEN + JML_MAX_SITELEN +
                         sizeof(UInt32)*4;
  */
  char* datachunk = (char*)xmalloc(512);
  char* dcp = datachunk;
  unsigned int datalen;
  char buf = 0;
  int i;
  UInt8 name_len, site_len;
  UInt8 nullbyte = 0;

  for (i=0;i<patt_size;i++) {
    name_len = (UInt8)strlen(patterns[i]->name); 
    site_len = (UInt8)strlen(patterns[i]->site); 
    datalen = 5 + name_len + site_len + sizeof(UInt32)*4;

    dcp = datachunk;

    memcpy(dcp, &(patterns[i]->id), 1);
    dcp++;

    memcpy(dcp, &name_len, 1);
    dcp++;
    memcpy(dcp, patterns[i]->name, name_len);
    dcp+=name_len;
    memcpy(dcp, &nullbyte, 1);
    dcp++;

    memcpy(dcp, &site_len, 1);
    dcp++;
    memcpy(dcp, patterns[i]->site, site_len);
    dcp+=site_len;
    memcpy(dcp, &nullbyte, 1);
    dcp++;

    //memcpy(dcp, &buf, 1); /* alignment buffer */
    //dcp++;
    memcpy(dcp, &(patterns[i]->hr), sizeof(UInt32));
    dcp+=sizeof(UInt32);
    memcpy(dcp, &(patterns[i]->dr), sizeof(UInt32));
    dcp+=sizeof(UInt32);
    memcpy(dcp, &(patterns[i]->style), sizeof(UInt32));
    dcp+=sizeof(UInt32);
    memcpy(dcp, &(patterns[i]->next_pattern), sizeof(Int32));

    new_record(datachunk, (unsigned short)datalen);
  }
  
  xfree(datachunk);
}

/* create a new record and add data */
void new_record(void* data, unsigned short len) {
  prc_record_t* rec = prcnewrecord();
  prcrecordset(rec, (prc_byte_t*)data, len);
  prcappendrecord(prc_handle, rec);
}
