/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * appiset.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdlib.h>
#include <string.h> /* for memcpy */

#include "prcp.h"

int
prcsetappinfo(prc_t* prc,
              prc_byte_t*   data,
              prc_uint16_t  datalen)
{
    void* cdata;

    if (data == NULL || datalen == 0) {
        datalen = 0;
        cdata = NULL;
    } else {
        cdata = (void*)malloc(datalen);
        memcpy(cdata, data, datalen);
    }

    if (prc->appinfoData != NULL)
        free(prc->appinfoData);

    prc->appinfoData = cdata;
    prc->appinfoSize = datalen;

    return 0;
}
