/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * create.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdio.h>
#include <fcntl.h>

#include "prcp.h"

prc_t*
prccreate(const char* filename,
          const char* name,
          prc_type_t  type,
          prc_type_t  cid,
          prc_attr_t  attrs)
{
    prc_t* prc = prcopen(filename, PRC_OPEN_CREATE);

    if (!prc)
        return prc;

    prcsetname(prc, name);
    prc->cid = cid;
    prc->type = type;
    prc->ctime = prc->mtime = prctime(NULL);
    prc->btime = 0;
    prc->flags = attrs;

    return prc;
}

