/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * destroy.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdlib.h>

#include "prcp.h"

int
prcdestroy(prc_t* prc)
{
    prc_internal_t* iprc = (prc_internal_t*)prc;
    prc_internal_record_t* foo;
    prc_internal_record_t* next;
    int rv = 0;

    for (foo = iprc->records; foo != NULL; foo = next) {
        next = foo->next;

        if (foo->u_contents.record.data != NULL)
            free(foo->u_contents.record.data);
        free(foo);
    }

    if (NULL != iprc->header.appinfoData)
        free(iprc->header.appinfoData);
    if (NULL != iprc->header.sortinfoData)
        free(iprc->header.sortinfoData);

    free(prc);

    return rv;
}
