/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * fwhead.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdlib.h>
#include <memory.h>
#include <string.h>

#include "prcp.h"

int
prcfwriteheader(FILE* fp, prc_t* prc)
{
    prc_file_t fbuf;
    prc_uint32_t appInfoOffset = 0;
    prc_uint32_t sortInfoOffset = 0;
    
    if (prc->appinfoData != NULL) {
        appInfoOffset = sizeof(prc_file_t) +
            (sizeof(prc_file_record_header_t) * prc->nrecords) +
            2;
    }
    
    if (prc->sortinfoData != NULL) {
        sortInfoOffset = sizeof(prc_file_t) + appInfoOffset +
            (sizeof(prc_file_record_header_t) * prc->nrecords) +
            2;
    }
    
    memset(&fbuf, 0, sizeof(prc_file_t));
    strncpy(&fbuf.name[0], prc->name, 32);

    prcuint16tobuf(&fbuf.flags, prc->flags);
    prcuint16tobuf(&fbuf.version, prc->version);
    prcuint32tobuf(&fbuf.ctime, prc->ctime);
    prcuint32tobuf(&fbuf.mtime, prc->mtime);
    prcuint32tobuf(&fbuf.btime, prc->btime);
    prcuint32tobuf(&fbuf.modnum, prc->modnum);
    prcuint32tobuf(&fbuf.cid, prc->cid);
    prcuint32tobuf(&fbuf.type, prc->type);
    prcuint16tobuf(&fbuf.nrecords, prc->nrecords);
    prcuint32tobuf(&fbuf.appinfo, appInfoOffset);
    prcuint32tobuf(&fbuf.sortinfo, sortInfoOffset);

    if (fwrite(&fbuf, sizeof(prc_file_t), 1, fp) != 1)
        return -1;

    return 0;
}
