/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * open.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdio.h>
#include <fcntl.h>

#include "prcp.h"

prc_t*
prcopen(const char* name, unsigned mode)
{
    const char* modes;
    FILE* fp;
    prc_t* prc;
    
    if ((mode & PRC_OPEN_CREATE) != 0) {
        modes = "wb";
    } else {
        modes = "rb";
    }
    
    fp = fopen(name, modes);
    
    if (fp == NULL)
        return NULL;

    prc = prcfpopen(fp, mode);

    if ((mode & (PRC_OPEN_TOUCH|PRC_OPEN_UPDATE|PRC_OPEN_WRITE)) != 0) {
        prc_internal_t* iprc = (prc_internal_t*)prc;

        /* Now that we have read the old file, reopen for writing */
        fclose(fp);

        fp = fopen(name, "wb");

        if (fp == NULL)
            return NULL;
        iprc->fp = fp;
    }
    
    return prc;
}
