/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * prcp.h
 *
 * created: djw@djw.org, January 2, 1999.
 */
#ifndef _PRCP_H_
#define _PRCP_H_

#include <stdio.h>

#include <prc.h>

/* File header */
typedef struct prc_file_t {
    prc_byte_t name[32];
    prc_byte_t flags[2];
    prc_byte_t version[2];
    prc_byte_t ctime[4];
    prc_byte_t mtime[4];
    prc_byte_t btime[4];
    prc_byte_t modnum[4];
    prc_byte_t appinfo[4];
    prc_byte_t sortinfo[4];
    prc_byte_t type[4];
    prc_byte_t cid[4];
    prc_byte_t unique_id_seed[4];
    prc_byte_t next_record_list[4];
    prc_byte_t nrecords[2];
} prc_file_t;

/* File resource header */
typedef struct prc_file_resource_header_t {
    prc_byte_t type[4];
    prc_byte_t id[2];
    prc_byte_t offset[4];
} prc_file_resource_header_t;

/* File resource header */
typedef struct prc_resource_header_t {
    prc_uint32_t type;
    prc_uint32_t offset;
    prc_uint16_t id;
} prc_resource_header_t;

/* File record header */
typedef struct prc_file_record_header_t {
    prc_byte_t offset[4];
    prc_byte_t flags;
    prc_byte_t id[3];
} prc_file_record_header_t;

/* File record header */
typedef struct prc_record_header_t {
    prc_uint32_t offset;
    prc_uint32_t id;
    prc_byte_t   flags;
} prc_record_header_t;

/* CCYYMMDDhhmm */
#define PRC_TIME_DEFAULT_FORMAT "%C%y%m%d%H%M"
#define PRC_TIME_DEFAULT_FORMAT_LEN 12

#define MAC_MINUS_UNIX_TIME (2082844800L) /* from pilot */
/* 0x7c35b080 */

#define UNIX_TO_MAC_TIME(t) ((t)+MAC_MINUS_UNIX_TIME)
#define MAC_TO_UNIX_TIME(t) ((t)-MAC_MINUS_UNIX_TIME)

typedef struct prc_internal_record_t {
    union {
        prc_record_t   record;
        prc_resource_t resource;
    } u_contents;
    struct prc_internal_record_t* next;
} prc_internal_record_t;

#define PRC_RECORDTOINTERNAL(r) (prc_internal_record_t*)(r)
#define PRC_RESOURCETOINTERNAL(r) (prc_internal_record_t*)(r)

typedef struct prc_internal_t
{
    prc_t                  header;
    prc_internal_record_t* records;
    FILE*                  fp;
    unsigned               mode;
} prc_internal_t;

#define PRC_PRCTOINTERNAL(p) ((prc_internal_t*)(p))

prc_t* prcfpopen(FILE* fp, unsigned mode);
int prcfwriteheader(FILE* fp, prc_t*);
int prcfreadheader(FILE* fp, prc_t*, prc_uint32_t* appi, prc_uint32_t* sorti);
int prcfwriterecord(FILE* fp, prc_record_header_t*);
int prcfreadrecord(FILE* fp, prc_record_header_t*);
int prcfwriteresource(FILE* fp, prc_resource_header_t*);
int prcfreadresource(FILE* fp, prc_resource_header_t*);
int prcinitheader(prc_t* prc);
int prccommonset(prc_internal_record_t*, prc_byte_t* data, prc_uint16_t len);

/* misc buf to int, int to buf routines */
prc_uint16_t prcbuftouint16(const void*);
prc_uint32_t prcbuftouint32(const void*);
prc_uint32_t prcbuftouint24(const void*);
void         prcuint16tobuf(void*, prc_uint16_t);
void         prcuint32tobuf(void*, prc_uint32_t);
void         prcuint24tobuf(void*, prc_uint32_t);

/*
 * Compiler & platform specific hacks.
 */
#if defined(WIN32)
#define strncasecmp(a,b,n) _strnicmp((a), (b), (n))
#endif

#endif /*_PRCP_H_*/
