/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * recapp.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdlib.h>
#include <memory.h>

#include "prcp.h"

prc_record_t*
prcappendrecord(prc_t* prc, prc_record_t* rec)
{
    prc_internal_t* iprc = PRC_PRCTOINTERNAL(prc);
    prc_internal_record_t* prev;
    prc_internal_record_t* foo;
    prc_internal_record_t* newGuy = PRC_RECORDTOINTERNAL(rec);
    
    prev = NULL;
    for (foo = iprc->records; foo != NULL; prev = foo, foo = foo->next)
        ;
    
    if (prev != NULL) {
        prev->next = newGuy;
    } else {
        iprc->records = newGuy;
    }

    iprc->header.nrecords++;

    return &newGuy->u_contents.record;
}
