/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * recnext.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdlib.h>
#include <memory.h>

#include "prcp.h"

prc_record_t*
prcgetnextrecord(prc_t* prc, prc_record_t* last)
{
    prc_internal_t* iprc = PRC_PRCTOINTERNAL(prc);
    prc_internal_record_t* ilast = PRC_RECORDTOINTERNAL(last);
    prc_internal_record_t* inext;

    if (ilast == NULL)
        inext = iprc->records;
    else
        inext = ilast->next;

    return &inext->u_contents.record;
}
