/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * rsrcset.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdlib.h>
#include <string.h>

#include "prcp.h"

int
prccommonset(prc_internal_record_t* common,
             prc_byte_t*   data,
             prc_uint16_t  datalen)
{
    prc_resource_t* rsrc = (prc_resource_t*)common;
    void* cdata;

    if (data == NULL || datalen == 0) {
        datalen = 0;
        cdata = NULL;
    } else {
        cdata = (void*)malloc(datalen);
        memcpy(cdata, data, datalen);
    }

    if (rsrc->data != NULL)
        free(rsrc->data);

    rsrc->data = cdata;
    rsrc->datalen = datalen;

    return 0;
}

int
prcresourceset(prc_resource_t* rsrc,
               prc_uint32_t  type,
               prc_uint16_t  id,
               prc_byte_t*   data,
               prc_uint16_t  datalen)
{
    int rv;

    rv = prccommonset((prc_internal_record_t*)rsrc, data, datalen);

    if (rv != 0)
        return rv;

    rsrc->type = type;
    rsrc->id = id;

    return 0;
}
