/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * setname.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <string.h>
#include <memory.h>

#include "prcp.h"

void
prcsetname(prc_t* prc, const char* name)
{
    int len = strlen(name);
    if (len > PRC_MAX_NAMESIZE)
        len = PRC_MAX_NAMESIZE;

    memset(prc->name, 0, PRC_MAX_NAMESIZE); 
    memcpy(prc->name, name, len);
}

