/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * sortiset.c
 *
 * created: djw@djw.org, May 15, 1999.
 */
#include <stdlib.h>
#include <string.h>

#include "prcp.h"

int
prcsetsortinfo(prc_t* prc,
               prc_byte_t*   data,
               prc_uint16_t  datalen)
{
    void* cdata;

    if (data == NULL || datalen == 0) {
        datalen = 0;
        cdata = NULL;
    } else {
        cdata = (void*)malloc(datalen);
        memcpy(cdata, data, datalen);
    }

    if (prc->sortinfoData != NULL)
        free(prc->sortinfoData);

    prc->sortinfoData = cdata;
    prc->sortinfoSize = datalen;

    return 0;
}
