/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright 1999 David Williams. All rights reserved.
 *
 * timetos.c
 *
 * created: djw@djw.org, January 2, 1999.
 */
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "prcp.h"

char*
prctimetostr(char* buf, prc_time_t prc_time)
{
    time_t      utime;
    struct tm*  tm_p;
    size_t      rv = 0;
    const char* result_string = "error";

    if (prc_time == 0) {
        /*
         * Win32 localtime() can't deal with negative utime, so
         * handle the ones we care about here:
         */
        result_string = "190401010000";
    } else {
        /*
         * Of course all other early dates will fail, but we tried...
         */
        utime = MAC_TO_UNIX_TIME(prc_time);
        tm_p  = localtime(&utime);

        if (tm_p != NULL) {

            /* CCYYMMDDhhmm */
            rv = sprintf(buf,
                         "%04d%02d%02d%02d%02d",
                         (tm_p->tm_year + 1900),
                         (tm_p->tm_mon + 1),
                         tm_p->tm_mday,
                         tm_p->tm_hour,
                         tm_p->tm_min);
            
            if (rv == PRC_TIME_DEFAULT_FORMAT_LEN)
                result_string = buf;
        }
    }

    if (result_string != buf)
        strcpy(buf, result_string);
    
    return buf;
}
